package ru.yandex.tours.db

import slick.driver.MySQLDriver.api._
import scala.concurrent.{ExecutionContext, Future}

class Transactions(tag: Tag) extends Table[Transaction](tag, "transactions") {
  def id: Rep[Int] = column[Int]("id", O.PrimaryKey, O.AutoInc)

  def author: Rep[Long] = column[Long]("author")

  def timestamp: Rep[Long] = column[Long]("timestamp")

  def isEnabled: Rep[Boolean] = column[Boolean]("is_enabled")

  def isManual: Rep[Boolean] = author > 0L

  override def * = (id, author, timestamp, isEnabled).<>(Transaction.tupled, Transaction.unapply)
}

case class Transaction(id: Int, author: Long, timestamp: Long, isEnabled: Boolean) {
  def isManual: Boolean = author > 0
}

object Transactions {
  val table = TableQuery[Transactions]

  def newTransaction(db: DBWrapper,
                     author: Long = 0,
                     timestamp: Long = System.currentTimeMillis(),
                     isEnabled: Boolean = true)
                    (implicit ec: ExecutionContext): Future[Transaction] = {
    val futureId = (table returning table.map(_.id)) += Transaction(0, author, timestamp, isEnabled)
    db.run(futureId).map(id => Transaction(id, author, timestamp, isEnabled))
  }

  def withTransaction[T](db: DBWrapper,
                         author: Long = 0,
                         timestamp: Long = System.currentTimeMillis(),
                         isEnabled: Boolean = true)
                        (action: Transaction => Future[T])(implicit ec: ExecutionContext): Future[T] = {
    for {
      transaction <- newTransaction(db, author, timestamp, isEnabled)
      result <- action(transaction)
    } yield result
  }
}