package ru.yandex.tours.db.geomapping

import ru.yandex.tours.geo.mapping.GeoMappingShort

/**
  * Created by asoboll on 11.12.15.
  */
case class GeoMappingRecordExt(geoMappingRecord: GeoMappingRecord, time: Long, isManual: Boolean) extends Ordered[GeoMappingRecordExt] {
  def fullPartnerId = (geoMappingRecord.partner, geoMappingRecord.partnerId)

  def compare(that: GeoMappingRecordExt) = time compare that.time

  def toGeoMapping: GeoMappingShort = {
    geoMappingRecord.command match {
      case Add => GeoMappingShort(geoMappingRecord.partner, geoMappingRecord.geoId, geoMappingRecord.partnerId)
      case Drop => GeoMappingShort(geoMappingRecord.partner, geoMappingRecord.geoId, geoMappingRecord.partnerId)
      case _ => sys.error("Unexpected command in geo mapping")
    }
  }
}
