package ru.yandex.tours.db.geomapping

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.db.Transactions
import ru.yandex.tours.geo.mapping.GeoMappingShort
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.hotels.Partners.Partner
import slick.driver.MySQLDriver.api._

/**
  * Created by asoboll on 02.12.15.
  */
class GeoMappingTable private(tableName: String)(tag: Tag) extends Table[GeoMappingRecord](tag, tableName) {

  def this(dataType: DataType)(tag: Tag) = this(dataType.getName.split("[.]")(0))(tag)

  def id = column[Int]("id", O.PrimaryKey, O.AutoInc)

  def command = column[Int]("command")

  def partner = column[Int]("partner")

  def geoId = column[Int]("geo_id")

  def partnerId = column[String]("partner_id")

  def transactionId = column[Int]("transaction_id")

  def * = (id, command, partner, geoId, partnerId, transactionId).shaped <> ({
    case (id, comm, partnerCode, geoId, partnerId, transactionId) =>
      Partners.getOpt(partnerCode).map { partner =>
        GeoMappingRecord(id, Command(comm), partner, geoId, partnerId, transactionId)
      }.getOrElse(GeoMappingRecord.empty)
  }, {
    rec: GeoMappingRecord =>
      Some((rec.id, rec.command.code, rec.partner.id, rec.geoId, rec.partnerId, rec.transactionId))
  })

  def transactionFK = foreignKey("transaction_" + tableName, transactionId, Transactions.table)(_.id)
}

sealed abstract class Command(val code: Int)
object Command {
  def apply(code: Int) = code match {
    case -2 => Banned
    case -3 => UnBanned
    case -1 => Drop
    case 1 => Add
  }
}

case object Banned extends Command(-2)
case object UnBanned extends Command(-3)
case object Drop extends Command(-1)
case object Add extends Command(1)

case class GeoMappingRecord(id: Int, command: Command, partner: Partner, geoId: Int, partnerId: String, transactionId: Int)
object GeoMappingRecord {
  def apply(command: Command, geoMappingShort: GeoMappingShort, transactionId: Int): GeoMappingRecord =
    this(0, command, geoMappingShort.partner, geoMappingShort.geoId, geoMappingShort.partnerId, transactionId)

  def empty = GeoMappingRecord(0, Drop, Partners.unknown, 0, "", 0)
}
