package ru.yandex.tours.db.model

import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel

case class DbPartnerHotel(id: Int,
                          hotel: PartnerHotel,
                          isNew: Boolean = true,
                          isDeleted: Boolean,
                          created: Long = System.currentTimeMillis(),
                          updated: Long = System.currentTimeMillis()) {
  require(id == hotel.getId, "Ids in table and in payload should match")
}

object DbPartnerHotel {
  def apply(hotel: PartnerHotel): DbPartnerHotel = DbPartnerHotel(hotel.getId, hotel, isDeleted = hotel.getIsDeleted)
}
