package ru.yandex.tours.db.tables

import ru.yandex.tours.db.GridPoint
import ru.yandex.tours.db.model.DbPartnerHotel
import ru.yandex.tours.geo.Geohash
import ru.yandex.tours.model.BaseModel.Point
import slick.driver.MySQLDriver.api._
import slick.lifted.{ForeignKeyQuery, Index, MappedProjection, ProvenShape}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 25.03.16
 */
class HotelCoordinates(tag: Tag) extends Table[(Int, Point, GridPoint)](tag, "hotel_coordinates") {
  def id: Rep[Int] = column[Int]("id", O.PrimaryKey)

  def geohash: Rep[Long] = column[Long]("geohash")
  def point: MappedProjection[Point, Long] = geohash <>(Geohash.decodePoint, p => Some(Geohash.encodePoint(p)))

  def gridIndex: Rep[Long] = column[Long]("grid_index")
  def gridPoint: MappedProjection[GridPoint, Long] = gridIndex <>(new GridPoint(_), (p: GridPoint) ⇒ Some(p.id))

  def geohashIndex: Index = index("idx_hotel_geohash", geohash, unique = false)
  def gridIndexIndex: Index = index("idx_grid_index", gridIndex, unique = false)

  def idForeignKey: ForeignKeyQuery[Hotels, DbPartnerHotel] = {
    foreignKey("hotels_fk", id, Hotels.table)(_.id, ForeignKeyAction.Restrict, ForeignKeyAction.Restrict)
  }

  override def * : ProvenShape[(Int, Point, GridPoint)] = (id, point, gridPoint)
}

object HotelCoordinates {
  val table = TableQuery[HotelCoordinates]
}