package ru.yandex.tours.db.tables

import ru.yandex.tours.db.model.DbPartnerHotel
import slick.driver.MySQLDriver.api._
import slick.lifted.{ForeignKeyQuery, Index, ProvenShape}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 25.03.16
 */
class HotelUrls(tag: Tag) extends Table[(Int, String)](tag, "hotel_urls") {
  def id: Rep[Int] = column[Int]("id", O.PrimaryKey)

  def url: Rep[String] = column[String]("url")

  def urlIndex: Index = index("idx_hotel_url", url, unique = false)

  def idForeignKey: ForeignKeyQuery[Hotels, DbPartnerHotel] = {
    foreignKey("hotels_fk", id, Hotels.table)(_.id, ForeignKeyAction.Restrict, ForeignKeyAction.Restrict)
  }

  override def * : ProvenShape[(Int, String)] = (id, url)
}

object HotelUrls {
  val table = TableQuery[HotelUrls]
}