package controllers

import models.GeoMappingForm
import models.RichRequest
import play.api.mvc.{Action, Controller}
import ru.yandex.tours.db.DBWrapper
import ru.yandex.tours.db.geomapping.DbGeoMappings
import ru.yandex.tours.db.searchsettings.DbSearchSettings
import ru.yandex.tours.geo.base.region
import ru.yandex.tours.util.Logging

import scala.concurrent.{Future, ExecutionContext}
/**
  * Created by asoboll on 15.12.15.
  */
class GeoMappingController(tree: region.Tree,
                           db: DBWrapper,
                           dbGeoMappings: DbGeoMappings,
                           searchSettings: DbSearchSettings)
                          (implicit ec: ExecutionContext) extends Controller with Logging {

  def save = Action.async { implicit req =>
    GeoMappingForm.form.bindFromRequest().fold(
      errors => Future.successful(Ok("Failed: " + errors)),
      regionMappings => {
        for {
          update <- dbGeoMappings.update(regionMappings, tree, req.uid)
          result <- tree.region(regionMappings.geoId) match {
            case Some(region) =>
              //Future.successful(Ok(regionMappings.toString))
              Future.successful(Redirect(routes.RegionsController.get(regionMappings.geoId)))
            case None =>
              val rootRegion = tree.root.get
              for {
                regionMappings <- dbGeoMappings.getRegionMapping(rootRegion.id, tree)
                regionSearchSettings <- searchSettings.getRegionSearchSettings(rootRegion)
              } yield
                NotFound(views.html.regions.region(rootRegion, regionMappings, regionSearchSettings))
          }
        } yield result
      }
    )
  }

  def edit(id: Int) = Action.async { implicit req =>
    for (regionMappings <- dbGeoMappings.getRegionMapping(id, tree)) yield
      Ok(views.html.geomappings.geomappings_region(regionMappings))
  }
}