package controllers

import play.api.Routes
import play.api.mvc.{Action, Controller}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 03.03.15
 */
object RootController extends Controller {

  def ping() = Action {
    Ok("0;OK")
  }

  def index() = Action { implicit req =>
    Ok(views.html.index())
  }

  def jsRoutes = Action { implicit request =>
    Ok(
      Routes.javascriptRouter("jsRoutes")(
        routes.javascript.RegionsController.get,
        routes.javascript.RegionsController.custom,
        routes.javascript.RegionsController.delete,
        routes.javascript.RegionsController.putSearchSettings,
        routes.javascript.PartnerRegionsController.view,
        routes.javascript.PartnerRegionsController.get,
        routes.javascript.HotelsController.publish,
        routes.javascript.HotelsController.linkWith,
        routes.javascript.HotelsController.link,
        routes.javascript.HotelsController.unlink,
        routes.javascript.HotelsController.setHotelRegion,
        routes.javascript.HotelsController.selectHotelFeature,
        routes.javascript.HotelsController.deleteHotelFeature,
        routes.javascript.HotelsController.selectHotelMainImage,
        routes.javascript.HotelsController.hideHotelImage,
        routes.javascript.HotelsController.selectHotelStars,
        routes.javascript.HotelsController.selectHotelType,
        routes.javascript.HotelsController.selectHotelPoint
      )
    ).as(JAVASCRIPT)
  }
}
