package controllers

import models.scheduler.SchedulerJob
import play.api.mvc.{Action, AnyContent, Controller}
import ru.yandex.tours.util.Logging
import ru.yandex.vertis.curator.recipes.map.ZooKeeperMap

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 13.07.16
 */
class SchedulerController(taskIsEnabledMap: ZooKeeperMap[Boolean]) extends Controller with Logging {


  def listJobs(): Action[AnyContent] = Action { implicit req ⇒
    val jobs = taskIsEnabledMap.snapshot.map {
      case (rawName, isEnabled) ⇒ SchedulerJob(rawName, isEnabled)
    }.toList.sortBy(j ⇒ j.component → j.name)
    Ok(views.html.scheduler.task_list(jobs))
  }

  def setJobEnabledStatus(id: String, newStatus: Boolean): Action[AnyContent] = Action { implicit req ⇒
    taskIsEnabledMap.put(id, newStatus, ephemeral = false)
    val msg = "Шедулерная джоба [" + id + (if (newStatus) "] включена" else "] выключена")
    Redirect(routes.SchedulerController.listJobs())
      .flashing("success" -> msg)
  }
}
