package controllers.suggest

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataTypes, CompositeDataDef}
import ru.yandex.tours.geo.partners.{PartnerTrees, PartnerRegion}
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.hotels.Partners._
import shapeless.{HNil, ::}

/**
  * Created by asoboll on 19.02.16.
  */
class PartnerGeoSuggestHolder(val partnerGeoSuggests: Map[Partner, PartnerGeoSuggest]) {
  def suggest(partnerName: String, query: String, count: Int): Seq[PartnerRegion] =
    if (Partners.values.map(_.toString).contains(partnerName))
      partnerGeoSuggests.get(Partners.withName(partnerName)).fold(Seq.empty[PartnerRegion])(_.suggest(query, count))
    else Seq.empty
}

object PartnerGeoSuggestHolder extends CompositeDataDef[PartnerGeoSuggestHolder, PartnerTrees :: HNil] {
  override def dependsOn: Set[DataType] = Set(DataTypes.partnerRegions)

  override def from(dependencies: PartnerTrees :: HNil): PartnerGeoSuggestHolder = {
    val partnerTrees :: HNil = dependencies
    val partnerGeoSuggests = for {
      (partner, partnerTree) <- partnerTrees.values
    } yield partner -> new PartnerGeoSuggestLight(partnerTree)
    new PartnerGeoSuggestHolder(partnerGeoSuggests)
  }
}