package controllers.suggest

import play.api.i18n.Messages
import play.api.libs.json.{JsArray, Json}
import play.api.mvc.{AnyContent, Action, Controller}
import ru.yandex.tours.geo.base.region
import ru.yandex.tours.geo.partners.PartnerRegion

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 27.11.15
 */
class SuggestController(geoSuggest: YandexGeoSuggest,
                        //partnerGeoSuggestHolder: PartnerGeoSuggestHolder,
                        tree: region.Tree) extends Controller {

  def suggestGeo(query: String): Action[AnyContent] = Action { implicit req =>
    val regions = geoSuggest.suggest(query, 10)

    val json = JsArray(regions.map { region =>
      Json.obj(
        "id" -> region.id,
        "name" -> region.name.ruName,
        "type" -> Messages(region.`type`.toString),
        "country" -> tree.country(region).map(_.name.ruName)
      )
    })

    Ok(json)
  }

  def suggestPartnerGeo(partner: String, query: String): Action[AnyContent] = Action { implicit req =>
    //val regions = partnerGeoSuggestHolder.suggest(partner, query, 10)
    val regions = Seq.empty[PartnerRegion]

    val json = JsArray(regions.map { region =>
      Json.obj(
        "id" -> region.id,
        "name" -> region.getName,
        "type" -> Messages(region.category.toString)
      )
    })

    Ok(json)
  }
}
