package models

import ru.yandex.tours.db.geomapping._
import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.db.geomapping.GeoMappingRecordProcessor

/**
  * Created by asoboll on 19.12.15.
  */
case class GeoIdMapping(partner: Partner, countryId: Option[String], cityId: Option[String],
                        departureId: Option[String], airportId: Option[String]) {
  def toMap(id: Option[String]) = for{id <- id} yield (partner, id)
  def countryMap = toMap(countryId)
  def cityMap = toMap(cityId)
  def departureMap = toMap(departureId)
  def airportMap = toMap(airportId)
}

object GeoMappingForm {
  import play.api.data.Form
  import play.api.data.Forms._

  val geoMappingMapper = mapping(
    "partner" -> nonEmptyText.transform[Partners.Value](Partners.withName, _.toString),
    "country_id" -> optional(nonEmptyText),
    "city_id" -> optional(nonEmptyText),
    "departure_id" -> optional(nonEmptyText),
    "airport_id" -> optional(nonEmptyText)
  )(GeoIdMapping.apply)(GeoIdMapping.unapply)

  val listMapper = mapping(
    "geo_id" -> number(),
    "ban_status" -> nonEmptyText.transform[BanStatus](text => if(text == "BannedThis") BannedThis else NotBanned, _.toString),
    "mappings" -> list(geoMappingMapper)
  )(
    (id, banStatus, list) => RegionGeoMappings(
      id,
      banStatus,
      GeoMappingRecordProcessor.combineDuplicates(list.flatMap(_.countryMap)),
      GeoMappingRecordProcessor.combineDuplicates(list.flatMap(_.cityMap)),
      GeoMappingRecordProcessor.combineDuplicates(list.flatMap(_.departureMap)),
      GeoMappingRecordProcessor.combineDuplicates(list.flatMap(_.airportMap))
    )
  )(
    regionMappings => Some((regionMappings.geoId, regionMappings.banStatus, regionMappings.keys.map(partner =>
      GeoIdMapping(
        partner,
        regionMappings.countryMap.get(partner),
        regionMappings.cityMap.get(partner),
        regionMappings.departureMap.get(partner),
        regionMappings.airportMap.get(partner)
      )
    ).toList)
  ))

  val form = Form(listMapper)
}
