package models

import ru.yandex.tours.hotels.clustering.ClusteringModel
import ru.yandex.tours.model.Image
import ru.yandex.tours.util.Collections._
import ru.yandex.tours.util.collections.Graph
import ru.yandex.tours.util.{ImageUtils, Logging}

import scala.collection.JavaConverters._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 28.04.16
 */
case class HotelComparisonLight(hotel1: DbPartnerHotel, hotel2: DbPartnerHotel, link: Option[LinkWithInfo],
                           clusteringModel: ClusteringModel) extends Logging{

  val rawHotel1 = hotel1.hotel.getRawHotel
  val rawHotel2 = hotel2.hotel.getRawHotel

  val partner1 = Partners(rawHotel1.getPartner)
  val partner2 = Partners(rawHotel2.getPartner)

  val distance = ru.yandex.tours.geo.distanceInKm(rawHotel1.getPoint, rawHotel2.getPoint)

  private val images = {
    (hotel1.hotel.getImagesList.asScala ++ hotel2.hotel.getImagesList.asScala)
      .map(img => img.getName -> img)
      .toMap
  }
  private val imageIndex = images.keys.zipWithIndex.toMap

  val similarImageClusters = {
    val aHashes = hotel1.hotel.getImagesList.asScala.filter(_.hasPHash).map(img => img.getName -> img.getPHash)
    val bHashes = hotel2.hotel.getImagesList.asScala.filter(_.hasPHash).map(img => img.getName -> img.getPHash)

    val pairs = for {
      (aName, aHash) ← aHashes.par
      (bName, bHash) ← bHashes.par
      if ImageUtils.pHashSimilarity(aHash, bHash) >= 0.85d
    } yield imageIndex(aName) -> imageIndex(bName)

    val graph = new Graph(pairs.seq)
    val reverseIndex = imageIndex.swap.toMap

    graph.getConnectedComponents.map(_.map(reverseIndex))
  }

  private val allSimilarImages = similarImageClusters.flatten.toSet

  val commonImages = {
    similarImageClusters.map { cluster =>
      cluster.map(images).map(Image.fromProto)
    }
  }

  val uniqueImages1 = {
    hotel1.hotel.getImagesList.asScala.filterNot(img => allSimilarImages.contains(img.getName)).map(Image.fromProto)
  }
  val uniqueImages2 = {
    hotel2.hotel.getImagesList.asScala.filterNot(img => allSimilarImages.contains(img.getName)).map(Image.fromProto)
  }
}
