package models

import scala.io.Source

object LtBash {
  def apply(enqueueUri: String, headers: List[(String, String)], hotelId: Option[String]): String = {
    val template = if (hotelId.isDefined) {
      Source.fromURL(getClass.getResource("/lt_hotel_bash.template"))
        .mkString
        .replaceAllLiterally("{hotel_id}", hotelId.get)
    }
    else {
      Source.fromURL(getClass.getResource("/lt_region_bash.template")).mkString
    }
    template
      .replaceAllLiterally("{headers}", flatHeaders(headers))
      .replaceAllLiterally("{enqueue}", enqueueUri)
  }

  private def flatHeaders(headers: List[(String, String)]): String = {
    val q = "\""
    headers.map(h => s"-H ${q}${h._1}: ${h._2}${q}").mkString(" ")
  }
}