import play.api.mvc.{RequestHeader, Security}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 28.05.15
 */
package object models {
  type LocalDate = org.joda.time.LocalDate

  type Region = ru.yandex.tours.geo.base.Region
  type Hotel = ru.yandex.tours.model.hotels.Hotel
  val Hotel = ru.yandex.tours.model.hotels.Hotel
  type DbPartnerHotel = ru.yandex.tours.db.model.DbPartnerHotel
  type CustomRegion = ru.yandex.tours.geo.base.custom.CustomRegion
  val CustomRegion = ru.yandex.tours.geo.base.custom.CustomRegion

  type LinkWithInfo = ru.yandex.tours.db.tables.Clusterization.LinkWithInfo

  type SearchType = ru.yandex.tours.model.search.SearchType.SearchType
  val SearchType = ru.yandex.tours.model.search.SearchType

  type Subscription = ru.yandex.tours.model.subscriptions.Subscription
  val Subscription = ru.yandex.tours.model.subscriptions.Subscription

  type Notification = ru.yandex.tours.model.subscriptions.Notification
  val Notification = ru.yandex.tours.model.subscriptions.Notification

  type FlightDay = ru.yandex.tours.calendar.Calendar.FlightDay
  type CalendarEntry = ru.yandex.tours.calendar.Calendar.CalendarEntry

  type Tree = ru.yandex.tours.geo.base.region.Tree
  type HotelsIndex = ru.yandex.tours.hotels.HotelsIndex
  val HotelsIndex = ru.yandex.tours.hotels.HotelsIndex

  val Partners = ru.yandex.tours.model.hotels.Partners

  val Speller = ru.yandex.tours.util.Speller

  implicit class RichRequest(req: RequestHeader) {
    def username: String = req.tags.getOrElse(Security.username, "")
    def uid: Long = req.tags.getOrElse("uid", "-1").toLong
  }
}
