package ru.yandex.tours.geocoder

import java.net.URLEncoder

import org.json._

import scala.collection.immutable.IndexedSeq
import scala.io.Source
import scala.util.Try
import scala.collection.JavaConversions._

/* @author berkut@yandex-team.ru */

object GeocoderClient {

  def request(query: String): Try[IndexedSeq[GeocoderResponse]] = {
    val q = URLEncoder.encode(query, "UTF-8")
    val url = s"http://geocode-net.int01e.tst.maps.yandex.ru/1.x/?geocode=$q&format=json&lang=en"
    Try {
      val x = new JSONObject(Source.fromURL(url).mkString)
      val body = x.getJSONObject("response").getJSONObject("GeoObjectCollection")
      val accuracy = body.getJSONObject("metaDataProperty").getJSONObject("GeocoderResponseMetaData").getJSONObject("InternalResponseInfo").getString("accuracy").toDouble
      val array = body.getJSONArray("featureMember")
      (0 until array.length()).map(i => parseFeatureMember(array.getJSONObject(i).getJSONObject("GeoObject"), accuracy))
    }
  }

  private def parseFeatureMember(x: JSONObject, accuracy: Double) = {
    val map = traverse(x)
    GeocoderResponse(map.getOrElse("CountryName", ""),
                     map.getOrElse("LocalityName", ""),
                     Array(map.getOrElse("ThoroughfareName", ""), map.getOrElse("PremiseNumber", "")).filter(_ != "").mkString(", "),
                     map("geoid").toInt,
                     Point(map("pos")),
                     map("precision"),
                     accuracy,
                     map("kind"))
  }

  private def traverse(x: JSONObject): Map[String, String] = {
    var ans = Map.empty[String, String]
    for (key <- x.keys.map(_.toString)) {
      x.get(key) match {
        case o: JSONObject => ans ++= traverse(o)
        case s: String => ans += key -> s
      }
    }
    ans
  }
}
