package ru.yandex.tours.geocoder

/* @author berkut@yandex-team.ru */

object Point {
  def apply(x: String): Point = {
    val parts = x.split(" ")
    Point(parts(1).toDouble, parts(0).toDouble)
  }
}

case class Point(latitude: Double, longitude: Double)

object GeocoderResponse {
  def parseDelimeted(it: Iterator[String]) = {
    val country = it.next()
    val locality = it.next()
    val address = it.next()
    val geoId = it.next().toInt
    val accuracy = it.next().toDouble
    val precision = it.next()
    val long = it.next().toDouble
    val lat = it.next().toDouble
    val kind = it.next()
    GeocoderResponse(country, locality, address, geoId, Point(long, lat), precision, accuracy, kind)
  }
}

case class GeocoderResponse(country: String,
                            locality: String,
                            address: String,
                            geoId: Int,
                            point: Point,
                            precision: String,
                            accuracy: Double,
                            kind: String = "UNKNOWN") {
  def toTabSeparated = {
    s"$country\t$locality\t$address\t$geoId\t$accuracy\t$precision\t${point.longitude}\t${point.latitude}\t$kind"
  }
}
