#!/bin/sh

. ./component.sh

JAVA_HOME=/usr/local/java8
PATH="$JAVA_HOME/bin:$PATH"
LANG=ru_RU.UTF8
PID_FILE=../$DAEMON.pid
GC_LOG=${DAEMON}-gc.log
mkdir -p logs

CLASSPATH=`find lib -name '*.jar' -printf '%p:'`$CLASSPATH

export PATH LANG JAVA_HOME CLASSPATH
#-agentpath:./libyjpagent.so \

java -classpath $CLASSPATH  \
     -Dfile.encoding=UTF8 \
     -Doracle.net.tns_admin=/etc/oracle \
     -showversion -server -Xverify:none \
     -Xmx1024m -Xms1024m \
     -Xmn512m \
     -XX:+AlwaysPreTouch \
     -XX:+UseParNewGC \
     -XX:+UseConcMarkSweepGC \
     -XX:MaxTenuringThreshold=1 \
     -XX:SurvivorRatio=23 \
     -XX:+CMSScavengeBeforeRemark \
     -XX:CMSInitiatingOccupancyFraction=45 \
     -XX:+UseCMSInitiatingOccupancyOnly \
     -XX:+CMSParallelRemarkEnabled \
     -XX:+UseTLAB \
     -XX:+UseCondCardMark -XX:+UseNUMA \
     -XX:+HeapDumpOnOutOfMemoryError \
     -XX:HeapDumpPath=$HPROF_DIR \
     -XX:OnOutOfMemoryError="echo on oom killing process %p; kill -9 %p" \
     -Xloggc:logs/$GC_LOG \
     -XX:+PrintCommandLineFlags \
     -XX:+PrintGCApplicationStoppedTime \
     -XX:+PrintGCDetails \
     -XX:+PrintGCDateStamps \
     -Dcom.sun.management.jmxremote \
     -Dcom.sun.management.jmxremote.port=36403 \
     -Dcom.sun.management.jmxremote.local.only=false \
     -Dcom.sun.management.jmxremote.authenticate=false \
     -Dcom.sun.management.jmxremote.ssl=false \
     -Djava.rmi.server.hostname=`/bin/hostname --fqdn` \
     -Dhost.name=`/bin/hostname --fqdn` \
     -Djava.net.preferIPv6Addresses=true \
     -Dsun.net.client.defaultConnectTimeout=10000 \
     -Dsun.net.client.defaultReadTimeout=10000 \
     -Dsun.net.inetaddr.ttl=86400 -Dhttp.keepAlive=false \
     -Dlogging.path=logs \
     ru.yandex.tours.ApiMain >> logs/$DAEMON.log.shell 2>&1 &

echo $! > $PID_FILE