package ru.yandex.tours.api

import ru.yandex.tours.model.search.SearchResults.SearchProgress
import ru.yandex.tours.util.Metrics

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 25.03.15
 */
class CacheMetrics(name: String) {
  private val metrics = Metrics("cache." + name)
  private val hitMeter = metrics.getMeter("hit")
  private val missMeter = metrics.getMeter("miss")
  private val completedResults = metrics.getMeter("completed")
  private val emptyResults = metrics.getMeter("empty")
  private val reqCountHistogram = metrics.getHistogram("req_count")

  def completed(reqIndex: Int, count: Int): Unit = {
    if (reqIndex == 0) hitMeter.mark()
    reqCountHistogram.update(reqIndex)
    completedResults.mark()
    if (count == 0) emptyResults.mark()
  }

  def notCompleted(reqIndex: Int): Unit = {
    if (reqIndex == 0) missMeter.mark()
  }

  def update(reqIndex: Int, progress: SearchProgress, count: Int): Unit = {
    if (progress.getIsFinished) completed(reqIndex, count)
    else notCompleted(reqIndex)
  }
}
