package ru.yandex.tours.api.v1

import akka.actor.{ActorRef, Props}
import ru.yandex.tours.util.spray.HttpHandler
import spray.http.StatusCodes

/* @author berkut@yandex-team.ru */

class ApiHandler(searchHandler: ActorRef,
                 recommendHandler: ActorRef,
                 statisticHandler: ActorRef,
                 hotelHandler: ActorRef,
                 agenciesHandler: ActorRef,
                 referenceHandler: ActorRef,
                 subscriptionsHandler: ActorRef,
                 resortSkiHandler: ActorRef,
                 usersHandler: ActorRef) extends HttpHandler {

  private val swaggerHandler = context.actorOf(Props[ru.yandex.util.spray.api.swagger.Handler], "swagger")
  private val documentation = new DocumentationHandler(context)

  override val route = pathPrefix("api" / "1.x") {
    pathPrefix("search") {
      http => searchHandler ! http
    } ~ pathPrefix("recommend") {
      http => recommendHandler ! http
    } ~ pathPrefix("statistic") {
      http => statisticHandler ! http
    } ~ pathPrefix("hotel") {
      http => hotelHandler ! http
    } ~ pathPrefix("agencies") {
      http => agenciesHandler ! http
    } ~ pathPrefix("reference") {
      http => referenceHandler ! http
    } ~ pathPrefix("subscriptions") {
      http => subscriptionsHandler ! http
    } ~ pathPrefix("resorts") {
      http => resortSkiHandler ! http
    } ~ pathPrefix("users") {
      http => usersHandler ! http
    } ~ {
      documentation.routes
    }
  } ~ pathPrefix("swagger") {
    http => swaggerHandler ! http
  } ~ pathEndOrSingleSlash {
    redirect("swagger/", StatusCodes.SeeOther)
  }
}
