package ru.yandex.tours.api.v1

import akka.actor.ActorRefFactory
import com.gettyimages.spray.swagger.SwaggerHttpService
import com.wordnik.swagger.model.ApiInfo

import scala.reflect.runtime.universe.{Type, typeOf}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 01.02.16
 */
class DocumentationHandler(val actorRefFactory: ActorRefFactory) extends SwaggerHttpService {
  override def apiTypes: Seq[Type] = Seq(
    typeOf[hotel.Documentation],
    typeOf[search.Documentation],
    typeOf[recommend.Documentation],
    typeOf[reference.Documentation],
    typeOf[statistic.Documentation],
    typeOf[resort.Documentation],
    typeOf[users.Documentation],
    typeOf[subscription.Documentation]
  )

  override def apiVersion: String = "1.x"
  override def baseUrl: String = "/api/1.x"
  override def docsPath: String = ""

  override def apiInfo: Option[ApiInfo] = Some(ApiInfo(
    title = "API Яндекс.Путешествий",
    description =
      """По всем вопросам обращаться в <a href="mailto:tourism-dev@yandex-team.ru">tourism-dev@yandex-team.ru</a>
      """,
    contact = "",
    termsOfServiceUrl = "",
    license = "", licenseUrl = ""
  ))
}
