package ru.yandex.tours.api.v1.recommend

import javax.ws.rs.Path

import com.wordnik.swagger.annotations.{Api, ApiImplicitParam, ApiImplicitParams, ApiOperation}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 08.04.16
 */
@Api(
  basePath = "/recommend",
  value = "/recommend",
  description = "Рекоммендации",
  produces = "application/json",
  position = 2
)
trait Documentation {

  //scalastyle:off

  @Path("/{context}")
  @ApiOperation(httpMethod = "GET", value = "Рекомендуемые курорты в стране", notes =
    """Возвращает JSON массив с направлениями.

       Параметр from можно заменить на geo_id
       Параметры uid, login, yuid можно заменить заголовком x-userid
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "context", dataType = "string", paramType = "path", allowableValues = "tours,rooms", required = true, defaultValue = "tours"),
    new ApiImplicitParam(name = "uid", dataType = "int", value = "uid залогинового пользователя", paramType = "query"),
    new ApiImplicitParam(name = "login", dataType = "string", value = "Логин пользователя", paramType = "query"),
    new ApiImplicitParam(name = "yuid", dataType = "string", value = "yuid анонимного пользователя", paramType = "query"),
    new ApiImplicitParam(name = "lang", dataType = "string", paramType = "query", allowableValues = "ru,en,kz,ua", defaultValue = "ru")
  ))
  def recommend()

  @Path("/resorts")
  @ApiOperation(httpMethod = "GET", value = "Рекомендуемые курорты в стране", notes =
    """Возвращает JSON массив с направлениями.

       Параметр from можно заменить на geo_id
       Параметры uid, login, yuid можно заменить заголовком x-userid
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "from", dataType = "int", value = "Город вылета", paramType = "query"),
    new ApiImplicitParam(name = "country_id", dataType = "int", value = "id страны", paramType = "query"),
    new ApiImplicitParam(name = "uid", dataType = "int", value = "uid залогинового пользователя", paramType = "query"),
    new ApiImplicitParam(name = "login", dataType = "string", value = "Логин пользователя", paramType = "query"),
    new ApiImplicitParam(name = "yuid", dataType = "string", value = "yuid анонимного пользователя", paramType = "query"),
    new ApiImplicitParam(name = "lang", dataType = "string", paramType = "query", allowableValues = "ru,en,kz,ua", defaultValue = "ru")
  ))
  def recommendResorts()
}
