package ru.yandex.tours.api.v1.reference

import javax.ws.rs.Path

import com.wordnik.swagger.annotations.{ApiResponse, _}
import spray.routing.HttpService

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 02.03.16
 */
@Api(
  basePath = "/reference",
  value = "/reference",
  description = "Почти статичная информация",
  produces = "application/json,plain/text",
  position = 3
)
trait Documentation extends HttpService {

  @Path("/departures")
  @ApiOperation(httpMethod = "GET", value = "Список городов вылета", notes =
    """Города вылета для саджеста на сервисе.
       Возвращает JSON массив с регионами, каждый регион – массив из 3 элементов:
         - id
         - название
         - название в родительном падеже
       Например:
         [213, 'Москва', 'Москвы']
    """)
  def departures()

  @Path("/region")
  @ApiOperation(httpMethod = "GET", value = "Получение региона", notes =
    """Получение информации про регион по id
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "id", dataType = "int", required = true, value = "id региона", paramType = "query")
  ))
  @ApiResponses(Array(
    new ApiResponse(code = 200, message = "JSON с информацией про регион"),
    new ApiResponse(code = 404, message = "Такого региона не существует")
  ))
  def region()

  @Path("/active_branding")
  @ApiOperation(httpMethod = "GET", value = "Активная кампания брендирования сервиса", notes =
    """Возвращает JSON массив с именем активной кампании.
       Если активной кампании нет массив возвращается пустым.
       Если передана дата – возвращает активную кампанию в эту дату
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "date", dataType = "date", paramType = "query")
  ))
  def activeBranding()

  @Path("/filter_channel_managers")
  @ApiOperation(httpMethod = "GET", value = "Фильтр отелей, подключенных через channel manager-ов",
    notes = "По набору id отелей возвращает JSON массив с парами id отеля и id channel manager-а")
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "ids", dataType = "int", allowMultiple = true, paramType = "query")
  ))
  def filterChannelManagers()
}
