package ru.yandex.tours.api.v1.search

import javax.ws.rs.Path

import com.wordnik.swagger.annotations._
import spray.routing.HttpService

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 01.02.16
 */
@Api(
  basePath = "/search",
  value = "/search",
  description = "Поиск туров, отелей, перелетов",
  produces = "application/json",
  position = 0
)
trait Documentation extends HttpService {

  //scalastyle:off

  @Path("/{context}/")
  @ApiOperation(httpMethod = "GET", value = "Поиск отельных сниппетов", position = 0, notes =
    """Необходимо вызывать до тех пор пока поле progress.is_complete не примет значение true.
       С каждым новым запросом необходимо увеличивать значение параметра request_index (начиная с 0).

       При поиске с context = rooms, параметр from не обязателен.
       Параметры flex_when и flex_nights работают только с context = tours.

       Если параметры when или nights не переданы, сервис попытается найти ближайшие к текущей дате, когда есть предложения.

       Рекомендуется передавать utm метки пользователя, а так же его идентификатор.
       Идентификатор пользователя можно передать параметрами uid, yuid и login или заголовком X-UserId в формате uid/login/yuid, например, X-UserId: 123/my_login/234414455

       Допустимые фильтры:
         * private_beach – (true|false)
         * hotel_line – (1|2|3)
         * beach – (sand|stone|mixed_sand_pebble|platform|pebble|concrete)
         * stars – (0..5)
         * wifi – (free)
         * hotel_type – ... https://hg.yandex-team.ru/tours/file/tip/tours-model-proto/src/main/proto/hotels/HotelsHolder.proto#l5
         * slope_distance_enum – (0|250|500|1000|1500|3000)
         * pansions – ... https://hg.yandex-team.ru/tours/file/tip/tours-model-proto/src/main/proto/base_model.proto#l3
         * price_from, price_to
         * tour_operator | hotel_provider
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "context", dataType = "string", paramType = "path", allowableValues = "tours,rooms", required = true, defaultValue = "tours"),
    new ApiImplicitParam(name = "from", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "to", dataType = "int", paramType = "query", required = true),
    new ApiImplicitParam(name = "when", dataType = "date", paramType = "query"),
    new ApiImplicitParam(name = "nights", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "ages", dataType = "int", paramType = "query", allowMultiple = true),
    new ApiImplicitParam(name = "flex_when", dataType = "boolean", paramType = "query", defaultValue = "false", value = "+- 2 дня к дате вылета"),
    new ApiImplicitParam(name = "flex_nights", dataType = "boolean", paramType = "query", defaultValue = "false", value = "+- 2 к числу ночей"),
    new ApiImplicitParam(name = "lang", dataType = "string", paramType = "query", allowableValues = "ru,en,kz,ua", defaultValue = "ru"),
    new ApiImplicitParam(name = "request_index", dataType = "int", paramType = "query", defaultValue = "0"),
    new ApiImplicitParam(name = "page_num", dataType = "int", paramType = "query", defaultValue = "1"),
    new ApiImplicitParam(name = "page_size", dataType = "int", paramType = "query", defaultValue = "20"),
    new ApiImplicitParam(name = "sort", dataType = "string", paramType = "query", defaultValue = "relevance", allowableValues = "relevance,price_asc,price_desc,rating_asc,rating_desc")
  ))
  def search()

  @Path("/{context}/map_info")
  @ApiOperation(httpMethod = "GET", value = "Найденные отели на карте", position = 1, notes =
    """Метод возвращает отели найденные в /search/{context}/, с ограничением по спану (bounding box).
       Допустима передача фильтров.

       В ответе для каждого отеля присутсвуют цены из кеша, и поле is_complete.
       Если is_complete = false, за поиском можно сходить в /hotel/{hotel_id}/min_prices.
       Если is_complete = true – ответ окончательный.

       Спан можно передать параметрами longitude, latitude, lon_span, lat_span;
       либо параметрами lat_min, lat_max, lon_min, lon_max
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "context", dataType = "string", paramType = "path", allowableValues = "tours,rooms", required = true, defaultValue = "tours"),
    new ApiImplicitParam(name = "from", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "to", dataType = "int", paramType = "query", required = true),
    new ApiImplicitParam(name = "when", dataType = "java.util.Date", paramType = "query"),
    new ApiImplicitParam(name = "nights", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "ages", dataType = "int", paramType = "query", allowMultiple = true),
    new ApiImplicitParam(name = "flex_when", dataType = "boolean", paramType = "query", defaultValue = "false", value = "+- 2 дня к дате вылета"),
    new ApiImplicitParam(name = "flex_nights", dataType = "boolean", paramType = "query", defaultValue = "false", value = "+- 2 к числу ночей"),
    new ApiImplicitParam(name = "lang", dataType = "string", paramType = "query", allowableValues = "ru,en,kz,ua", defaultValue = "ru")
  ))
  def mapInfo()

  @Path("/{context}/top")
  @ApiOperation(httpMethod = "GET", value = "Поиск топовых отелей", position = 2, notes =
    """Ищет топовые отели в регионе, по возможности обогощая их ценой из кеша.

       Рекомендуется передавать utm метки пользователя, а так же его идентификатор.
       Идентификатор пользователя можно передать параметрами uid, yuid и login или заголовком X-UserId в формате uid/login/yuid, например, X-UserId: 123/my_login/234414455
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "context", dataType = "string", paramType = "path", allowableValues = "tours,rooms", required = true, defaultValue = "tours"),
    new ApiImplicitParam(name = "from", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "to", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "when", dataType = "date", paramType = "query"),
    new ApiImplicitParam(name = "nights", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "ages", dataType = "int", paramType = "query", allowMultiple = true),
    new ApiImplicitParam(name = "flex_when", dataType = "boolean", paramType = "query", defaultValue = "false"),
    new ApiImplicitParam(name = "flex_nights", dataType = "boolean", paramType = "query", defaultValue = "false"),
    new ApiImplicitParam(name = "lang", dataType = "string", paramType = "query", allowableValues = "ru,en,kz,ua", defaultValue = "ru"),
    new ApiImplicitParam(name = "size", dataType = "int", paramType = "query", defaultValue = "6")
  ))
  def searchTop()

  @Path("/{context}/another")
  @ApiOperation(httpMethod = "GET", value = "Поиск фолбека", position = 3, notes =
    """Ищет предложения с альтернативными параметрами поиска для показа фолбека.
       Фолбек на сервисе показывается когда основной поиск вернул пустой результат.

       Возможные фолбеки:
         * near_date – соседняя дата вылета, соседнее число ночей
         * near_from – другой город вылета, например вылет из Москвы для Петербурга
         * country – поиск по стране, если поиск по конкретному городу ничего не нашел

       Фолбек использует длинный кеш, и не гарантирует что предложения всё ещё существуют.

       Рекомендуется передавать utm метки пользователя, а так же его идентификатор.
       Идентификатор пользователя можно передать параметрами uid, yuid и login или заголовком X-UserId в формате uid/login/yuid, например, X-UserId: 123/my_login/234414455
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "context", dataType = "string", paramType = "path", allowableValues = "tours,rooms", required = true, defaultValue = "tours"),
    new ApiImplicitParam(name = "from", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "to", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "when", dataType = "date", paramType = "query"),
    new ApiImplicitParam(name = "nights", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "ages", dataType = "int", paramType = "query", allowMultiple = true),
    new ApiImplicitParam(name = "flex_when", dataType = "boolean", paramType = "query", defaultValue = "false"),
    new ApiImplicitParam(name = "flex_nights", dataType = "boolean", paramType = "query", defaultValue = "false"),
    new ApiImplicitParam(name = "lang", dataType = "string", paramType = "query", allowableValues = "ru,en,kz,ua", defaultValue = "ru"),
    new ApiImplicitParam(name = "snippet_count", dataType = "int", paramType = "query", defaultValue = "6")
  ))
  def searchAnother()

  @Path("/hotels")
  @ApiOperation(httpMethod = "GET", value = "Поиск отелей на карте", position = 4, notes =
    """Поиск отелей в спане (bounding box).
       В отличии от /search/{context}/map_info не привязана к результатам основного поиска.
       Так же не поддерживаются фильтры (по крайней мере пока...).

       В ответе для каждого отеля присутсвуют цены из кеша, и поле is_complete.
       Если is_complete = false, за поиском можно сходить в /hotel/{hotel_id}/min_prices.
       Если is_complete = true – ответ окончательный.

       Можно передать параметр hotel_id чтобы гарантировать наличие отеля в ответе.

       Спан можно передать параметрами longitude, latitude, lon_span, lat_span;
       либо параметрами lat_min, lat_max, lon_min, lon_max
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "from", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "to", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "when", dataType = "java.util.Date", paramType = "query"),
    new ApiImplicitParam(name = "nights", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "ages", dataType = "int", paramType = "query", allowMultiple = true),
    new ApiImplicitParam(name = "flex_when", dataType = "boolean", paramType = "query", defaultValue = "false"),
    new ApiImplicitParam(name = "flex_nights", dataType = "boolean", paramType = "query", defaultValue = "false"),
    new ApiImplicitParam(name = "lang", dataType = "string", paramType = "query", allowableValues = "ru,en,kz,ua", defaultValue = "ru"),
    new ApiImplicitParam(name = "max_size", dataType = "int", paramType = "query", defaultValue = "200"),
    new ApiImplicitParam(name = "hotel_id", dataType = "int", paramType = "query")
  ))
  def hotels()

  @Path("/flights")
  @ApiOperation(httpMethod = "GET", value = "Поиск авиаперелетов", position = 5, notes =
    """Необходимо вызывать до тех пор пока поле progress.is_complete не примет значение true.
       С каждым новым запросом необходимо увеличивать значение параметра request_index (начиная с 0).

       В поле alternatives представлены возможные значения для городов вылета и прилета.
       Для смены города вылета следует передать поле from_override.
       Для смены аэропорта назначения следует передать параметр airport_id
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "from", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "to", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "when", dataType = "java.util.Date", paramType = "query"),
    new ApiImplicitParam(name = "nights", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "ages", dataType = "int", paramType = "query", allowMultiple = true),
    new ApiImplicitParam(name = "from_override", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "airport_id", dataType = "string", paramType = "query"),
    new ApiImplicitParam(name = "lang", dataType = "string", paramType = "query", allowableValues = "ru,en,kz,ua", defaultValue = "ru"),
    new ApiImplicitParam(name = "request_index", dataType = "int", paramType = "query", defaultValue = "0")
  ))
  def flights()

  @Path("/transfers")
  @ApiOperation(httpMethod = "GET", value = "Поиск трансферов и проката машин", position = 6, notes =
    """Необходимо вызывать до тех пор пока поле progress.is_complete не примет значение true.
       С каждым новым запросом необходимо увеличивать значение параметра request_index (начиная с 0).

       Для смены аэропорта назначения следует передать параметр airport_id.
       При only_cheapest = true показываются только самые дешевые предложения в трех категориях:
       прокате, такси и общественном транспорте (до 3 штук)
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "hotel_id", dataType = "int", paramType = "query", required = true),
    new ApiImplicitParam(name = "only_cheapest", dataType = "boolean", paramType = "query", defaultValue = "true"),
    new ApiImplicitParam(name = "from", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "when", dataType = "java.util.Date", paramType = "query"),
    new ApiImplicitParam(name = "nights", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "ages", dataType = "int", paramType = "query", allowMultiple = true),
    new ApiImplicitParam(name = "airport_id", dataType = "string", paramType = "query"),
    new ApiImplicitParam(name = "lang", dataType = "string", paramType = "query", allowableValues = "ru,en,kz,ua", defaultValue = "ru"),
    new ApiImplicitParam(name = "request_index", dataType = "int", paramType = "query", defaultValue = "0")
  ))
  def transfers()
}
