package ru.yandex.tours.api.v1.search

import akka.actor.ActorRef
import ru.yandex.tours.util.spray.HttpHandler
import spray.routing.Route

class RootSearchHandler(toursSearchHandler: ActorRef,
                        roomsSearchHandler: ActorRef,
                        flightsSearchHandler: ActorRef,
                        transfersSearchHandler: ActorRef
                       ) extends HttpHandler {

  override val route: Route = {
    pathPrefix("tours") {
      ctx => toursSearchHandler ! ctx
    } ~ pathPrefix("rooms") {
      ctx => roomsSearchHandler ! ctx
    } ~ pathPrefix("flights") {
      ctx => flightsSearchHandler ! ctx
    } ~ pathPrefix("transfers") {
      ctx => transfersSearchHandler ! ctx
    } ~ {
      ctx => toursSearchHandler ! ctx
    }
  }
}
