package ru.yandex.tours.api.v1.subscription

import javax.ws.rs.Path

import com.wordnik.swagger.annotations.{Api, ApiImplicitParam, ApiImplicitParams, ApiOperation}
import spray.routing.HttpService

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 01.02.16
 */
@Api(
  basePath = "/subscriptions",
  value = "/subscriptions",
  description = "Подписки",
  produces = "application/json",
  position = 7
)
trait Documentation extends HttpService {

  @Path("/query")
  @ApiOperation(httpMethod = "GET", value = "Превращает поисковый запрос в Proto модель для подписок", notes =
    """Метод вызывается сервисом подписок для унификации запроса
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "from", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "to", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "when", dataType = "date", paramType = "query"),
    new ApiImplicitParam(name = "nights", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "ages", dataType = "int", paramType = "query", allowMultiple = true),
    new ApiImplicitParam(name = "flex_when", dataType = "boolean", paramType = "query", defaultValue = "false"),
    new ApiImplicitParam(name = "flex_nights", dataType = "boolean", paramType = "query", defaultValue = "false")
  ))
  def query()
}
