package ru.yandex.tours.api.v1.users

import javax.ws.rs.Path

import com.wordnik.swagger.annotations.{Api, ApiImplicitParam, ApiImplicitParams, ApiOperation}
import spray.routing.HttpService

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 11.05.16
 */
@Api(
  basePath = "/users/{uid}",
  value = "/users",
  description = "Пользователи",
  produces = "application/json",
  position = 6
)
trait Documentation extends HttpService {

  //scalastyle:off

  @Path("/history")
  @ApiOperation(httpMethod = "GET", value = "Получение истории просмотров", notes =
    """
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "uid", dataType = "int", paramType = "path", required = true),
    new ApiImplicitParam(name = "limit", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "lang", dataType = "string", paramType = "query", allowableValues = "ru,en,kz,ua", defaultValue = "ru")
  ))
  def history()

  @Path("/history/{hotel_id}")
  @ApiOperation(httpMethod = "PUT", value = "Сохранение отеля в историю просмотров", notes =
    """Сохраняет отель в список просмотренных.
       Принимает json объект с ценами
       {
         "room_price": 11000,
         "tour_price": 42010,
         "flight_price": 39000
       }

       Можно вызывать несколько раз, добавляя новую информацию по мере появления.
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "uid", dataType = "int", paramType = "path", required = true),
    new ApiImplicitParam(name = "hotel_id", dataType = "int", paramType = "path"),
    new ApiImplicitParam(name = "from", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "when", dataType = "java.util.Date", paramType = "query"),
    new ApiImplicitParam(name = "nights", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "ages", dataType = "int", paramType = "query", allowMultiple = true),
    new ApiImplicitParam(name = "flex_when", dataType = "boolean", paramType = "query", defaultValue = "false", value = "+- 2 дня к дате вылета"),
    new ApiImplicitParam(name = "flex_nights", dataType = "boolean", paramType = "query", defaultValue = "false", value = "+- 2 к числу ночей"),
    new ApiImplicitParam(name = "body", dataType = "string", paramType = "body")
  ))
  def putHistory()

  @Path("/history/{hotel_id}")
  @ApiOperation(httpMethod = "POST", value = "Обновление отеля в истории просмотров", notes =
    """Обновляет данные связанные с отелем в истории просмотренных.
       Принимает json объект с ценами
       {
         "room_price": 11000,
         "tour_price": 42010,
         "flight_price": 39000
       }

       Можно вызывать несколько раз, добавляя новую информацию по мере появления.
       Если отеля не было в истории – ничего не происходит.
       Если отель был в истории – его положение не изменяется
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "uid", dataType = "int", paramType = "path", required = true),
    new ApiImplicitParam(name = "hotel_id", dataType = "int", paramType = "path"),
    new ApiImplicitParam(name = "from", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "when", dataType = "java.util.Date", paramType = "query"),
    new ApiImplicitParam(name = "nights", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "ages", dataType = "int", paramType = "query", allowMultiple = true),
    new ApiImplicitParam(name = "flex_when", dataType = "boolean", paramType = "query", defaultValue = "false", value = "+- 2 дня к дате вылета"),
    new ApiImplicitParam(name = "flex_nights", dataType = "boolean", paramType = "query", defaultValue = "false", value = "+- 2 к числу ночей"),
    new ApiImplicitParam(name = "body", dataType = "string", paramType = "body")
  ))
  def updateHistory()

  @Path("/favorites")
  @ApiOperation(httpMethod = "GET", value = "Получение избранного", notes =
    """
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "uid", dataType = "int", paramType = "path", required = true),
    new ApiImplicitParam(name = "page_num", dataType = "int", paramType = "query", defaultValue = "1"),
    new ApiImplicitParam(name = "page_size", dataType = "int", paramType = "query", defaultValue = "20"),
    new ApiImplicitParam(name = "country_ids", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "city_ids", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "lang", dataType = "string", paramType = "query", allowableValues = "ru,en,kz,ua", defaultValue = "ru")
  ))
  def favorites()

  @Path("/favorites/statistics")
  @ApiOperation(httpMethod = "GET", value = "Получение статистики цен для избранного", notes =
    """
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "uid", dataType = "int", paramType = "path", required = true),
    new ApiImplicitParam(name = "lang", dataType = "string", paramType = "query", allowableValues = "ru,en,kz,ua", defaultValue = "ru")
  ))
  def favoritesStatistics()

  @Path("/favorites/check")
  @ApiOperation(httpMethod = "GET", value = "Проверка отелей на избранность", notes =
    """Список hotel_ids можно передать в нескольких параметрах (hotel_ids=1&hotels_ids=2)
       или в одном через запятую (hotel_ids=1,2)
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "uid", dataType = "int", paramType = "path", required = true),
    new ApiImplicitParam(name = "hotel_ids", dataType = "int", paramType = "query", allowMultiple = true)
  ))
  def favoritesCheck()

  @Path("/favorites/{hotel_id}")
  @ApiOperation(httpMethod = "PUT", value = "Сохранение отеля в избранное", notes =
    """Сохраняет отель в список избранного.
       Если отель уже был в избранном – обновляет сохраненный поисковый запрос, время просмотра и цены.
       Принимает json объект с ценами:
       {
         "room_price": 11000,
         "tour_price": 42010,
         "flight_price": 39000
       }

       Если поисковый запрос не указан – сгенерируется запрос по умолчанию.
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "uid", dataType = "int", paramType = "path", required = true),
    new ApiImplicitParam(name = "hotel_id", dataType = "int", paramType = "path"),
    new ApiImplicitParam(name = "from", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "when", dataType = "java.util.Date", paramType = "query"),
    new ApiImplicitParam(name = "nights", dataType = "int", paramType = "query"),
    new ApiImplicitParam(name = "ages", dataType = "int", paramType = "query", allowMultiple = true),
    new ApiImplicitParam(name = "flex_when", dataType = "boolean", paramType = "query", defaultValue = "false", value = "+- 2 дня к дате вылета"),
    new ApiImplicitParam(name = "flex_nights", dataType = "boolean", paramType = "query", defaultValue = "false", value = "+- 2 к числу ночей"),
    new ApiImplicitParam(name = "body", dataType = "string", paramType = "body")
  ))
  def putFavorites()

  @Path("/favorites/{hotel_id}")
  @ApiOperation(httpMethod = "DELETE", value = "Удаление отеля из избранного", notes =
    """
    """)
  @ApiImplicitParams(Array(
    new ApiImplicitParam(name = "uid", dataType = "int", paramType = "path", required = true),
    new ApiImplicitParam(name = "hotel_id", dataType = "int", paramType = "path")
  ))
  def deleteFavorites()
}
