package ru.yandex.tours.api.v1.view

import org.json.{JSONArray, JSONObject}
import ru.yandex.tours.api.JsonSerialization
import ru.yandex.tours.api.JsonSerialization._
import ru.yandex.tours.avia.AviaAirportRecommendations.AirportRecommendation
import ru.yandex.tours.geo.base.region
import ru.yandex.tours.model.Languages.Lang
import ru.yandex.tours.model.Prices.FlightMinPriceMatrix
import ru.yandex.tours.model.search.FlightSearchRequest

import scala.collection.JavaConverters._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 17.02.16
 */
class FlightAlternativesView(request: FlightSearchRequest,
                             departureVariants: Seq[Int],
                             airportVariants: Seq[AirportRecommendation],
                             matrix: FlightMinPriceMatrix) {

  private val prices = matrix.getPriceEntityList.asScala.map { priceEntity =>
    (priceEntity.getFrom, priceEntity.getAirportId) -> priceEntity.getMinPrice
  }.toMap

  private def getPrice(from: Int, airport: String): Option[Int] = prices.get(from -> airport)

  def isEmpty: Boolean = departureVariants.isEmpty || airportVariants.isEmpty

  def asJson(tree: region.Tree, lang: Lang): JSONObject = {
    def regionToJson(id: Int) = {
      val res = JsonSerialization.regionToJson(id, tree, lang)
      getPrice(id, request.airportId).foreach(res.put("min_price", _))

      res
    }
    def airportToJson(airport: AirportRecommendation) = {
      val res = JsonSerialization.toJson(airport, tree, lang)
      getPrice(request.hotelRequest.from, airport.city.id).foreach(res.put("min_price", _))
      res
    }

    new JSONObject()
      .put("departures", departureVariants.map(regionToJson).asJavaCollection)
      .put("airports", airportVariants.map(airportToJson).asJavaCollection)
  }
}
