package ru.yandex.tours.backend

import ru.yandex.tours.backend.HotelSnippetPreparer.HotelContextualMinPrice
import ru.yandex.tours.model.hotels.Hotel
import ru.yandex.tours.model.search.HotelSearchRequest
import ru.yandex.tours.model.{HotelProvider, TourOperator}

import scala.concurrent.{ExecutionContext, Future}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 21.01.16
 */
class HotelMinPricePreparer(toursPreparer: HotelSnippetPreparer[TourOperator],
                            roomsPreparer: HotelSnippetPreparer[HotelProvider])
                           (implicit ec: ExecutionContext) {

  def getHotelMinPrice(request: HotelSearchRequest, hotel: Hotel): Future[HotelMinPrice] = {
    val toursFuture = toursPreparer.getHotelMinPrice(request.hotelRequest, hotel)
    val roomsFuture = roomsPreparer.getHotelMinPrice(request.hotelRequest, hotel)
    for {
      tours <- toursFuture
      rooms <- roomsFuture
    } yield HotelMinPrice(tours, rooms)
  }

  def getHotelsMinPrice(request: HotelSearchRequest, hotels: Seq[Hotel]): Future[Map[Hotel, HotelMinPrice]] = {
    val toursFuture = toursPreparer.getHotelsMinPrice(request, hotels)
    val roomsFuture = roomsPreparer.getHotelsMinPrice(request, hotels)
    for {
      tours <- toursFuture
      rooms <- roomsFuture
    } yield {
      hotels.map { hotel =>
        hotel -> HotelMinPrice(tours(hotel), rooms(hotel))
      }.toMap
    }
  }

}

case class HotelMinPrice(isComplete: Boolean, tourMinPrice: Option[Int], roomMinPrice: Option[Int])

object HotelMinPrice {
  def apply(tours: HotelContextualMinPrice, rooms: HotelContextualMinPrice): HotelMinPrice = {
    HotelMinPrice(tours.isFinished && rooms.isFinished, tours.minPrice, rooms.minPrice)
  }
}