package ru.yandex.tours.backend

import ru.yandex.tours.billing.{BillingIndex, BillingService}
import ru.yandex.tours.filter.SnippetFiltrator
import ru.yandex.tours.geo.base.region
import ru.yandex.tours.hotels.{HotelRatings, HotelsIndex, HotelsSimilarity}
import ru.yandex.tours.model.TourOperator
import ru.yandex.tours.model.search.SearchResults.ActualizedOffer
import ru.yandex.tours.model.search.{GetOfferRequest, SearchType}
import ru.yandex.tours.operators.SearchSources
import ru.yandex.tours.search.settings.SearchSettingsHolder
import ru.yandex.tours.services.OfferSearchService

import scala.concurrent.{Future, ExecutionContext}

/* @author berkut@yandex-team.ru */

class OfferPreparer(searcher: OfferSearchService,
                    hotelsIndex: HotelsIndex,
                    hotelsSimilarity: HotelsSimilarity,
                    tree: region.Tree,
                    snippetFiltrator: SnippetFiltrator,
                    billingService: BillingService,
                    billingIndex: BillingIndex,
                    cmBillingIndex: BillingIndex,
                    searchSources: SearchSources[TourOperator],
                    hotelRatings: HotelRatings,
                    searchSettings: SearchSettingsHolder)(implicit ec: ExecutionContext)
  extends HotelSnippetPreparer[TourOperator](
    searcher,
    hotelsIndex,
    hotelsSimilarity,
    tree,
    snippetFiltrator,
    hotelRatings,
    billingService,
    billingIndex,
    cmBillingIndex,
    searchSources,
    SearchType.TOURS,
    searchSettings) {

  def getOffer(request: GetOfferRequest): Future[Option[ActualizedOffer]] = {
    searcher.searchOffer(request)
  }

  def getActualizedOffer(request: GetOfferRequest): Future[Option[ActualizedOffer]] = {
    searcher.actualizeOffer(request)
  }
}