package ru.yandex.tours.ota

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataTypes, DataDef}
import ru.yandex.tours.model.ota.OnlineTourAgency
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}

import scala.io.Source

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 13.05.15
 */
class OtaMapping(known: Set[(Int, Int)]) {
  def this() = this(Set.empty)
  def isKnown(agency: OnlineTourAgency, id: Int): Boolean = known.contains((agency.id, id))
}

class OtaMappingDef(val dataType: DataType) extends DataDef[OtaMapping] {
  override def parse(is: InputStream): OtaMapping = {
    val mapping = Source.fromInputStream(is).getLines().map {
      case Tabbed(IntValue(agencyId), IntValue(key), _) => agencyId -> key
    }.toSet
    new OtaMapping(mapping)
  }
}

object OtaHotelMapping extends OtaMappingDef(DataTypes.otaHotelMappings)
object OtaOperatorMapping extends OtaMappingDef(DataTypes.otaOperatorMappings)
object OtaCityMapping extends OtaMappingDef(DataTypes.otaCitiesMappings)
