package ru.yandex.tours.ota

import java.io.File

import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.tours.extdata.ExtDataUpdateChecker
import ru.yandex.tours.model.TourOperator
import ru.yandex.tours.model.ota.OnlineTourAgency

object OtaMappingHolder {
  def parse(hotels: File, operators: File, cities: File): OtaMappingHolder = {
    new OtaMappingHolder(
      OtaHotelMapping.fromFile(hotels),
      OtaOperatorMapping.fromFile(operators),
      OtaCityMapping.fromFile(cities)
    )
  }
  def from(extDataService: ExtDataService, extDataUpdateChecker: ExtDataUpdateChecker) = {
    new OtaMappingHolder(
      OtaHotelMapping.from(extDataService, extDataUpdateChecker),
      OtaOperatorMapping.from(extDataService, extDataUpdateChecker),
      OtaCityMapping.from(extDataService, extDataUpdateChecker)
    )
  }
}

class OtaMappingHolder(hotelMapping: OtaMapping,
                       operatorMapping: OtaMapping,
                       citiesMapping: OtaMapping) {

  def isKnownHotel(agency: OnlineTourAgency, hotelId: Int) = hotelMapping.isKnown(agency, hotelId)
  def isKnownOperator(agency: OnlineTourAgency, operator: TourOperator) = operatorMapping.isKnown(agency, operator.id)
  def isKnownCity(agency: OnlineTourAgency, geoId: Int) = citiesMapping.isKnown(agency, geoId)
}