package ru.yandex.tours.ota

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataTypes, DataDef}
import ru.yandex.tours.util.parsing.{LongValue, DoubleValue, Tabbed}

class PartnerStatisticHolder(id2conversion: Map[String, Double], id2calculatedCpc: Map[String, Long]) {
  def getConversion(id: String): Double = id2conversion.getOrElse(id, 0)
  def getCalculatedCpc(id: String): Option[Long] = id2calculatedCpc.get(id)
}

object PartnerStatisticHolder extends DataDef[PartnerStatisticHolder] {
  override def dataType: DataType = DataTypes.partnerConversion

  override def parse(is: InputStream): PartnerStatisticHolder = {
    val parsed = scala.io.Source.fromInputStream(is).getLines().map {
      case Tabbed(id, DoubleValue(conversion)) => 
        (id -> conversion, None)
      case Tabbed(id, DoubleValue(conversion), LongValue(cpc)) =>
        (id -> conversion, Some(id -> cpc))
      case Tabbed(id, DoubleValue(conversion), "") =>
        (id -> conversion, None)
    }.toVector
    val id2conversion = parsed.map(_._1).toMap
    val id2cpc = parsed.flatMap(_._2).toMap
    new PartnerStatisticHolder(id2conversion.toMap, id2cpc)
  }
}
