#!/bin/sh

. ./component.sh

JAVA_HOME=/usr/local/java8
PATH="$JAVA_HOME/bin:$PATH"
LANG=ru_RU.UTF8
PID_FILE=../$DAEMON.pid
GC_LOG=${DAEMON}-gc.log

CLASSPATH=`find lib -name '*.jar' -printf '%p:'`$CLASSPATH

export PATH LANG JAVA_HOME CLASSPATH
#-agentpath:./libyjpagent.so \

java -classpath $CLASSPATH  \
     -Dfile.encoding=UTF8 \
     -Doracle.net.tns_admin=/etc/oracle \
     -showversion -server -Xverify:none \
     -Xmx512m -Xms512m \
     -XX:+AlwaysPreTouch \
     -XX:+UseG1GC \
     -XX:+UseTLAB \
     -XX:+UseCondCardMark -XX:+UseNUMA \
     -XX:+HeapDumpOnOutOfMemoryError \
     -XX:HeapDumpPath=$HPROF_DIR \
     -XX:OnOutOfMemoryError="echo on oom killing process %p; kill -9 %p" \
     -Xloggc:$GC_LOG \
     -XX:+PrintCommandLineFlags \
     -XX:+PrintGCApplicationStoppedTime \
     -XX:+PrintGCDetails \
     -XX:+PrintGCDateStamps \
     -Dhost.name=`/bin/hostname --fqdn` \
     -Ddc.name=sas \
     -Djava.net.preferIPv6Addresses=true \
     -Dsun.net.client.defaultConnectTimeout=10000 \
     -Dsun.net.client.defaultReadTimeout=10000 \
     -Dsun.net.inetaddr.ttl=86400 -Dhttp.keepAlive=false \
     -Dlogging.path=. \
     ru.yandex.tours.CalendarMain >> $DAEMON.log.shell 2>&1 &

echo $! > $PID_FILE