package ru.yandex.tours

import akka.actor.Props
import ru.yandex.tours.services._
import ru.yandex.tours.util.spray.{HttpHandler, RouteesContext}
import ru.yandex.tours.util.zoo.SharedValue
import spray.routing.Route

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 03.03.16
 */
class CalendarApiHandler(routeesContext: RouteesContext,
                         calendarService: CalendarService,
                         calendarPushService: CalendarPushService,
                         toursMinPriceService: MinPriceService,
                         roomsMinPriceService: MinPriceService,
                         enableWrites: SharedValue[Boolean],
                         enableReads: SharedValue[Boolean]
                        ) extends HttpHandler {

  override def route: Route = {
    pathPrefix("api" / "1.x") {
      pathPrefix("calendar") {
        RemoteCalendarService.routes(calendarService)
      } ~ pathPrefix("calendar" / "push") {
        RemoteCalendarPushService.routes(calendarPushService, routeesContext)
      } ~ pathPrefix("tours") {
        RemoteMinPriceService.routes(toursMinPriceService, routeesContext.searchRequest)
      } ~ pathPrefix("rooms") {
        RemoteMinPriceService.routes(roomsMinPriceService, routeesContext.roomSearchRequest)
      } ~ (path("chwrites") & post & parameter("enable".as[Boolean])) { enable =>
        enableWrites.set(enable)
        val msg = if (enable) "Enabled writing to clickhouse" else "Disabled writing to clickhouse"
        log.info(msg)
        complete(msg)
      } ~ (path("chreads") & post & parameter("enable".as[Boolean])) { enable =>
        enableReads.set(enable)
        val msg = if (enable) "Enabled reading from clickhouse" else "Disabled reading from clickhouse"
        log.info(msg)
        complete(msg)
      }
    }
  }
}

object CalendarApiHandler {
  def props(routeesContext: RouteesContext,
            calendarService: CalendarService,
            calendarPushService: CalendarPushService,
            toursMinPriceService: MinPriceService,
            roomsMinPriceService: MinPriceService,
            enableWrites: SharedValue[Boolean],
            enableReads: SharedValue[Boolean]
           ): Props = {
    Props(new CalendarApiHandler(routeesContext, calendarService, calendarPushService,
      toursMinPriceService, roomsMinPriceService, enableWrites, enableReads))
  }
}