package ru.yandex.tours.calendar

import ru.yandex.tours.calendar.storage.{FlightsStorage, PriceStorage}
import ru.yandex.tours.model.search.SearchResults.{ActualizedOffer, FlightSearchResult, HotelSearchResult, OfferSearchResult}
import ru.yandex.tours.model.search.{FlightSearchRequest, GetOfferRequest, HotelSearchRequest, OfferSearchRequest}
import ru.yandex.tours.services.CalendarPushService
import ru.yandex.tours.util.Logging
import ru.yandex.tours.util.zoo.SharedValue

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 28.03.16
 */
class LocalCalendarPushService(tourStorage: PriceStorage,
                               roomStorage: PriceStorage,
                               flightsStorage: FlightsStorage,
                               enableWrites: SharedValue[Boolean])
  extends CalendarPushService with Logging {

  override def saveTourSnippets(request: HotelSearchRequest, response: HotelSearchResult): Future[Unit] = {
    if (enableWrites.get) tourStorage.saveSnippets(request, response)
    Future.successful(())
  }

  override def saveTourOffers(request: OfferSearchRequest, response: OfferSearchResult): Future[Unit] = {
    if (enableWrites.get) tourStorage.saveOffers(request, response)
    Future.successful(())
  }

  override def saveRoomSnippets(request: HotelSearchRequest, response: HotelSearchResult): Future[Unit] = {
    // UNUSED if (enableWrites.get) roomStorage.saveSnippets(request, response)
    Future.successful(())
  }

  override def saveRoomOffers(request: OfferSearchRequest, response: OfferSearchResult): Future[Unit] = {
    // UNUSED if (enableWrites.get) roomStorage.saveOffers(request, response)
    Future.successful(())
  }

  override def saveActualization(request: GetOfferRequest, actualized: ActualizedOffer): Future[Unit] = {
    Future.successful(())
  }

  override def saveFlights(request: FlightSearchRequest, response: FlightSearchResult): Future[Unit] = {
    flightsStorage.saveFlightTrips(request, response)
    Future.successful(())
  }
}
