package ru.yandex.tours.agencies

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}
import ru.yandex.tours.model.Agencies.ProtoAgency
import ru.yandex.tours.model.Agency
import ru.yandex.tours.util.lang._
import ru.yandex.tours.util.{Logging, ProtoIO}

import scala.util.Try

class Agencies(id2agency: Map[Long, Agency]) {
  def get(id: Long): Option[Agency] = id2agency.get(id)
  def isEmpty: Boolean = id2agency.isEmpty
}

object Agencies extends DataDef[Agencies] with Logging {
  override def dataType: DataType = DataTypes.agenciesProto

  override def parse(is: InputStream): Agencies = {
    var errors = 0
    val agencies = for {
      protoAgency ← ProtoIO.loadFromStream(is, ProtoAgency.PARSER)
      agency ← Try(Agency.parseAgency(protoAgency)).onFailure { case e => errors += 1 } .toOption
    } yield agency.id → agency
    val map = agencies.toMap
    log.info(s"${map.size} parsed. $errors failed to parse.")
    new Agencies(map)
  }
}
