package ru.yandex.tours.agencies

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}

object AgencyPartneringIndex extends DataDef[AgencyPartneringIndex] {
  override def dataType: DataType = DataTypes.offlineAgencyPartnering

  override def parse(is: InputStream): AgencyPartneringIndex = {
    new AgencyPartneringIndex(parseMapping(is))
  }

  def parseMapping(is: InputStream) = {
    scala.io.Source.fromInputStream(is).getLines().map { l =>
      val parts = l.split("\t")
      parts(0).toLong -> parts.tail.map(_.toInt).toSet
    }.toMap
  }
}

class AgencyPartneringIndex(agency2notPartnered: Map[Long, Set[Int]]) {
  def getNotPartnered(id: Long) = agency2notPartnered.getOrElse(id, Set.empty)
}
