package ru.yandex.tours.agencies

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataTypes, DataDef}
import ru.yandex.tours.util.Logging
import ru.yandex.tours.util.lang._

import scala.util.Try

object CustomerToOperatorIndex extends DataDef[CustomerToOperatorIndex] with Logging {
  override def dataType: DataType = DataTypes.customerToOperator

  override def parse(is: InputStream): CustomerToOperatorIndex = {
    val mapping = scala.io.Source.fromInputStream(is).getLines().flatMap {
      case line => (Try {
        val parts = line.split("\t")
        parts(0).toInt -> parts(1).toLong
      } onFailure {
        e => log.warn(s"Can not parse `customer to operator` mapping: $line")
      }).toOption
    }
    new CustomerToOperatorIndex(mapping.toMap)
  }

  val empty = new CustomerToOperatorIndex(Map.empty[Int, Long])
}

class CustomerToOperatorIndex(operator2customer: Map[Int, Long]) {
  def getClient(operator: Int) = operator2customer.get(operator)
}
