package ru.yandex.tours.app

import akka.actor.ActorSystem
import ru.yandex.tours.util.UnhandledMessagesHandler

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 15.01.15
 */
trait AkkaSupport { this: Application =>

  lazy val akkaSystem = ActorSystem(serviceName, config)

  onStart {
    UnhandledMessagesHandler.initialize(akkaSystem)
  }

  onStop {
    akkaSystem.terminate()
  }
}
