package ru.yandex.tours.app

import ru.yandex.tours.avia._
import ru.yandex.tours.extdata.ExtDataSupport
import shapeless.HNil

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 15.01.16
 */
trait AviaClientSupport {
  this: Application
    with HttpSupport with AkkaSupport
    with CommonDataHolders with ExtDataSupport =>

  import akkaSystem.dispatcher

  lazy val aviaCities = AviaCities.from(extDataService, extDataUpdateChecker)

  lazy val airportRecommendations = {
    AviaAirportRecommendations.from(regionTree :: aviaCities :: HNil, extDataService, extDataUpdateChecker)
  }

  lazy val aviaCacheClient = new AviaCacheClient(httpClient, airportRecommendations)(dispatcher)

  lazy val useSimpleAvia: Boolean = {
    val conf = config.getConfig("avia")
    if (conf.hasPath("use_simple"))conf.getBoolean("use_simple") else true
  }

  lazy val aviaClient: AviaClient = {
    val conf = config.getConfig("avia")
    val default = new DefaultAviaClient(
      httpClient,
      conf.getString("rasp_uri"),
      conf.getString("uri"),
      conf.getString("app_key"),
      conf.getString("oauth_token")
    )
    val instrumented = new InstrumentedAviaClient(default)
    new MonitoredAviaClient(instrumented)
  }

}
