package ru.yandex.tours.app

import ru.yandex.tours.calendar.{CachingCalendarService, ClickHouseCalendarService}
import ru.yandex.tours.clickhouse.ClickHouseSupport
import ru.yandex.tours.services.{CalendarPushService, CalendarService, RemoteCalendarPushService, RemoteCalendarService}
import ru.yandex.tours.util.zoo.{BooleanSerializer, SharedValue}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 13.11.15
 */
trait CalendarServiceSupport {
  def calendarService: CalendarService
}

trait CalendarPushServiceSupport {
  def calendarPushService: CalendarPushService
}

trait LocalCalendarServiceSupport extends CalendarServiceSupport {
  self: Application with AkkaSupport with CommonDataHolders with ClickHouseSupport with ZookeeperSupport =>

  import akkaSystem.dispatcher

  lazy val enableReads = new SharedValue[Boolean](zkClient, "/clickhouse/calendar_rd_en", false, BooleanSerializer)

  lazy val calendarService: CalendarService = {
    val ch = new ClickHouseCalendarService(clickHouseClient, Some(enableReads))(dispatcher)
    new CachingCalendarService(ch)(dispatcher)
  }
}

trait RemoteCalendarServiceSupport extends CalendarServiceSupport {
  self: Application with AkkaSupport with HttpSupport =>

  import akkaSystem.dispatcher

  lazy val calendarService: CalendarService = RemoteCalendarService.fromConfig(httpClient, config)
}

trait RemoteCalendarPushServiceSupport extends CalendarPushServiceSupport {
  self: Application with AkkaSupport with HttpSupport =>

  import akkaSystem.dispatcher

  lazy val calendarPushService: CalendarPushService = RemoteCalendarPushService.fromConfig(httpClient, config)
}