package ru.yandex.tours.app

import ru.yandex.common.monitoring.jetty.MonitoringEmbeddedJetty

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 18.06.15
 */
trait EmbeddedJettyMonitoring { this: Application with MetricsSupport with HealthChecksSupport =>

  onStart {
    val port = this.config.getInt("monitoring.port")
    val jetty = MonitoringEmbeddedJetty.apply(port, this.healthChecksRegistry, this.metricsRegistry)
    onStop {
      jetty.server.stop()
    }
  }
}
