package ru.yandex.tours.app

import com.codahale.metrics.health.HealthCheckRegistry
import ru.yandex.common.monitoring.{CompoundHealthCheckRegistry, HealthChecks}

import scala.collection.JavaConverters._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 24.02.15
 */
trait HealthChecksSupport { this: Application =>
  def healthChecksRegistry: HealthCheckRegistry
  def developerChecksRegistry: HealthCheckRegistry
  def compoundChecksRegistry: CompoundHealthCheckRegistry
}

trait DefaultHealthChecksSupport extends HealthChecksSupport { this: Application =>
  override def healthChecksRegistry: HealthCheckRegistry = HealthChecks.defaultRegistry()
  override def developerChecksRegistry: HealthCheckRegistry = HealthChecks.compoundRegistry().getDeveloperChecks
  override def compoundChecksRegistry: CompoundHealthCheckRegistry = HealthChecks.compoundRegistry()

  onStop {
    healthChecksRegistry.getNames.asScala.foreach(healthChecksRegistry.unregister)
    developerChecksRegistry.getNames.asScala.foreach(developerChecksRegistry.unregister)
  }
}
