package ru.yandex.tours.app

import com.typesafe.config.ConfigException
import ru.yandex.tours.util.http
import ru.yandex.tours.util.http.NingHttpClient

trait HttpSupport {
  def httpProxy: Option[(String, Int)]
  
  def httpClient: http.AsyncHttpClient
  def externalHttpClient: http.AsyncHttpClient
}

trait DefaultHttpSupport extends HttpSupport { app: Application with AkkaSupport =>
  private val httpDispatcher = akkaSystem.dispatchers.lookup("akka.actor.http-client-dispatcher")

  override lazy val httpProxy = try {
    if (isEnvironmentLocal) {
      None
    } else {
      Some(app.config.getString("tours.proxy.host") -> app.config.getInt("tours.proxy.port"))
    }
  } catch {
    case _: ConfigException.Missing => None
  }

  override lazy val httpClient = new NingHttpClient(proxy = None)(httpDispatcher)

  override lazy val externalHttpClient = new NingHttpClient(httpProxy)(httpDispatcher)
}
