package ru.yandex.tours.app

import ru.yandex.tours.services.users.{UserFavoritesServiceImpl, UserHistoryServiceImpl}
import ru.yandex.tours.services.{UserFavoritesService, UserHistoryService}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 02.06.16
 */
trait UserServicesSupport {
  this: Application ⇒

  def userHistoryService: UserHistoryService

  def userFavoritesService: UserFavoritesService
}

trait RemoteUserServicesSupport extends UserServicesSupport {
  this: Application with AkkaSupport with HttpSupport ⇒

  import akkaSystem.dispatcher

  override val userHistoryService: UserHistoryService = {
    UserHistoryServiceImpl.fromConfig(httpClient, this.config.getConfig("personal"))
  }

  override val userFavoritesService: UserFavoritesService = {
    UserFavoritesServiceImpl.fromConfig(httpClient, this.config.getConfig("personal"))
  }
}
