package ru.yandex.tours.avia

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}
import ru.yandex.tours.util.IO

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 18.02.16
 */
class AviaCities(cities: Seq[AviaCity]) extends Serializable {
  private val byIdMap = cities.map(c => c.id -> c).toMap
  private val byGeoIdMap = cities.flatMap(c => c.geoId.map(_ -> c)).toMap

  def byId(id: String): Option[AviaCity] = {
    if (id.startsWith("c")) byIdMap.get(id)
    else if (id.startsWith("g")) byGeoId(id.drop(1).toInt)
    else None
  }
  def byGeoId(geoId: Int): Option[AviaCity] = byGeoIdMap.get(geoId)
}

object AviaCities extends DataDef[AviaCities] {
  override def dataType: DataType = DataTypes.aviaCities

  override def parse(is: InputStream): AviaCities = {
    val cities = IO.readLines(is).flatMap(l => AviaCity.unapply(l)).toList
    new AviaCities(cities)
  }

  def empty: AviaCities = new AviaCities(Seq.empty)
}
