package ru.yandex.tours.avia

import org.joda.time.DateTimeZone
import ru.yandex.tours.model.LocalizedString
import ru.yandex.tours.util.lang._
import ru.yandex.tours.util.parsing.{AtSKV, IntValue, Tabbed}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 18.02.16
 */
case class AviaCity(id: String,
                    name: LocalizedString,
                    geoId: Option[Int],
                    iata: Option[String],
                    tz: Option[DateTimeZone]) {

  require(id.startsWith("c"), "aviaCity id should starts with 'c'")
}

object AviaCity {
  def unapply(line: String): Option[AviaCity] = {
    line match {
      case Tabbed(aviaId, AtSKV(name), geoId, iata, tz) =>
        Some(AviaCity(
          aviaId,
          LocalizedString.fromMap(name),
          IntValue(geoId),
          optional(iata.nonEmpty, iata),
          if (tz.nonEmpty) Some(DateTimeZone.forID(tz)) else None
        ))
      case _ =>
        None
    }
  }
}