package ru.yandex.tours.avia

import org.joda.time.{DateTime, Duration}
import ru.yandex.tours.model.search.SearchProducts.FlightTrip

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 17.03.16
 */
trait FlightUtils {
  def getFlightDuration(flights: Seq[FlightTrip.Flight]): Duration = {
    getFlightDuration(flights.head, flights.last)
  }

  def getFlightDuration(first: FlightTrip.Flight, second: FlightTrip.Flight): Duration = {
    val start = first.getDepartureTime
    val end = second.getArrivalTime

    new Duration(DateTime.parse(start), DateTime.parse(end))
  }

  def getTransitionDuration(first: FlightTrip.Flight, second: FlightTrip.Flight): Duration = {
    val start = first.getArrivalTime
    val end = second.getDepartureTime

    new Duration(DateTime.parse(start), DateTime.parse(end))
  }
}

object FlightUtils extends FlightUtils
