package ru.yandex.tours.avia

import ru.yandex.tours.avia.AviaClient.{Dictionaries, Response, RaspResponse, ResponseUpdated}
import ru.yandex.tours.model.search.FlightSearchRequest
import ru.yandex.tours.util.Metrics
import ru.yandex.tours.util.lang.Futures._

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 22.03.16
 */
class InstrumentedAviaClient(client: AviaClient) extends AviaClient {

  private val metrics = Metrics("avia.client")
  private val getTimer = metrics.getTimer("get")
  private val getWithUpdateTimer = metrics.getTimer("get_with_update")
  private val getUpdatedTimer = metrics.getTimer("get_updated")
  private val getErrors = metrics.getMeter("errors.get")
  private val getWithUpdateErrors = metrics.getMeter("errors.get_with_update")
  private val getUpdatedErrors = metrics.getMeter("errors.get_updated")

  override def getMinPriceFromRasp(request: FlightSearchRequest): Future[RaspResponse] = {
    val ctx = getTimer.time()
    val errorReservoir = getErrors
    client.getMinPriceFromRasp(request)
      .withTimerContext(ctx)
      .withErrorRateMeter(errorReservoir)
  }

  override def getMinPrice(request: FlightSearchRequest, update: Boolean): Future[Response] = {
    val ctx = (if (update) getWithUpdateTimer else getTimer).time()
    val errorReservoir = if (update) getWithUpdateErrors else getErrors
    client.getMinPrice(request, update)
      .withTimerContext(ctx)
      .withErrorRateMeter(errorReservoir)
  }

  override def getMinPriceUpdated(searchId: String): Future[ResponseUpdated] = {
    val ctx = getUpdatedTimer.time()
    client.getMinPriceUpdated(searchId)
      .withTimerContext(ctx)
      .withErrorRateMeter(getUpdatedErrors)
  }

  override def getDictionaries: Future[Dictionaries] = client.getDictionaries
}
